import plus
import math

def overvolt():

    players = list(plus.getPlayers())
    for player in players:
        # Clear lists starting with each player.
        highpowermotorlist = []
        weaponlist = []
        componentlist = []
        wheellist = []

        # Convert string component list into a Python list separated by newlines.
        compstr = plus.describe(player)
        complist = compstr.splitlines()

        for comp in range(len(complist)):
            # For every possible component ID, check if it is a motor.
            if complist[comp] == str(comp) + " SpinMotor":
                # If it is, add that ID to either the drive or weapon motor list, depending on whether the HP is even or odd.
                if plus.getHitpoints(player, comp)%2 == 0:
                    highpowermotorlist.append(comp)
            if complist[comp] == str(comp) + " Weapon":
                weaponlist.append(comp)
            if complist[comp] == str(comp) + " Component":
                componentlist.append(comp)
            if complist[comp] == str(comp) + " Wheel":
                wheellist.append(comp)

        if len(highpowermotorlist) >= 2:
            motorcount = 200
        else:
            motorcount = 0

        # Check if we are running too many high power motors
        if motorcount == 200:
                plus.disable(player, 1)
                plus.zap(player, 10, 5)

#        for weapon in weaponlist:
#            plus.damage(player, weapon, plus.getHitpoints(player, weapon)*motorcount, plus.getLocation(player))
#        for wheel in wheellist:
#            plus.damage(player, wheel, plus.getHitpoints(player, wheel)*motorcount, plus.getLocation(player))
#        for component in componentlist:
#            plus.damage(player, component, plus.getHitpoints(player, component)*motorcount, plus.getLocation(player))
 
 
def oldovervolt():
    # This is the original code that gets voltage based on the number of control boards.  I wrote this before I thought of using an HP-based component identification system, which is far more flexible.  The new code is above.
    players = list(plus.getPlayers())
    for player in players:
        # Clear lists starting with each player.
        motorlist = []
        battlist = []
        # Calculate voltage multiplier based on number of control boards, to a maximum of 3x (72 volts).
        if plus.describe(player).count("ControlBoard") == 1: voltage = 0
        elif plus.describe(player).count("ControlBoard") == 2: voltage = -0.5
        elif plus.describe(player).count("ControlBoard") == 3: voltage = -1
        elif plus.describe(player).count("ControlBoard") == 4: voltage = -1.5
        elif plus.describe(player).count("ControlBoard") >= 5: voltage = -2
        
        compstr = plus.describe(p)
        complist = compstr.splitlines()
        for comp in range(len(complist)):
            # For every possible component ID, check if it is a motor.
            # Note: Servos appear to be unaffected by changes in HP, but I'm leaving them in here for no reason.
            if complist[comp] == str(comp) + " SpinMotor" or complist[comp] == str(comp) + " BurstMotor" or complist[comp] == str(comp) + " ServoMotor" :
                # If it is, add that ID to the motorlist.
                motorlist.append(comp)
            # For every possible component ID, check if it is a battery.
            if complist[comp] == str(comp) + " Battery":
                # If it is, add that ID to the battery list.
                battlist.append(comp)

        #file("describe.txt", "w").write(str(motorlist))
        for motor in motorlist:
            # Add hitpoints to all spin motors to increase power, based on voltage.
            plus.damage(player, motor, plus.getHitpoints(player, motor)*voltage, plus.getLocation(player))
        for battery in battlist:
            # Add hitpoints to all batteries to increase lifespan, based on voltage (higher = less life).
            # Note: Each 100% HP worth of damage equals a 50% increase/decrease in capacity.  Minimum capacity is therefore 50%, so we have to add hitpoints for lower-voltage bots instead of subtract hitpoints for high-voltage bots if we want to simulate 40% or 33% capacity.
            if voltage == 0: plus.damage(player, battery, plus.getHitpoints(player, battery)*-4, plus.getLocation(player))
            elif voltage == -0.5: plus.damage(player, battery, plus.getHitpoints(player, battery)*-2, plus.getLocation(player))
            elif voltage == -1: plus.damage(player, battery, plus.getHitpoints(player, battery)*-1, plus.getLocation(player))
            elif voltage == -1.5: plus.damage(player, battery, plus.getHitpoints(player, battery)*-0.4, plus.getLocation(player))